/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.laf;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.laf.LookChoiceStrategies;
import com.jgoodies.uif.laf.LookChoiceStrategy;
import com.jgoodies.uif.laf.LookConfiguration;
import com.jgoodies.uif.laf.LookConfigurations;
import com.jgoodies.uif.util.ComponentTreeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class ExtUIManager {
    public static final String DEFAULT_LAF_KEY = "laf.default";
    private static final Logger LOGGER = Logger.getLogger("ExtUIManager");
    private static LookChoiceStrategy lookChoiceStrategy = LookChoiceStrategies.DEFAULT;
    private static LookConfigurations lookConfigurations;
    private static List supportedLafs;

    private ExtUIManager() {
    }

    public static LookChoiceStrategy getLookChoiceStrategy() {
        return lookChoiceStrategy;
    }

    public static void setLookChoiceStrategy(LookChoiceStrategy lookChoiceStrategy) {
        ExtUIManager.lookChoiceStrategy = lookChoiceStrategy;
    }

    public static LookConfigurations getLookConfigurations() {
        if (lookConfigurations == null) {
            lookConfigurations = LookConfigurations.restoreFrom(Application.getUserPreferences());
        }
        return (LookConfigurations)lookConfigurations.clone();
    }

    public static void setLookConfigurations(LookConfigurations lookConfigurations) {
        if (lookConfigurations.equals(ExtUIManager.lookConfigurations)) {
            return;
        }
        ExtUIManager.lookConfigurations = lookConfigurations;
        lookConfigurations.storeIn(Application.getUserPreferences());
        ExtUIManager.setLookAndTheme(lookConfigurations.getDefaultConfiguration());
        ComponentTreeUtils.updateAllUIs();
    }

    public static void setup() {
        UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
        ExtUIManager.setLookAndTheme(ExtUIManager.getDefaultLookConfiguration());
    }

    public static String getDefaultLookClassName() {
        return Application.getUserPreferences().get(DEFAULT_LAF_KEY, ExtUIManager.getLookChoiceStrategy().getDefaultLookClassName());
    }

    public static LookAndFeel getDefaultLookAndFeel() {
        String string = ExtUIManager.getDefaultLookClassName();
        LookAndFeel lookAndFeel = ExtUIManager.createLookAndFeelInstance(string);
        if (lookAndFeel != null) {
            return lookAndFeel;
        }
        LOGGER.warning("Could not create the default L&F " + string);
        return UIManager.getLookAndFeel();
    }

    public static LookConfiguration getDefaultLookConfiguration() {
        return LookConfiguration.restoreFrom(ExtUIManager.getDefaultLookAndFeel(), Application.getUserPreferences());
    }

    public static void setDefaultLookAndFeel(LookAndFeel lookAndFeel) {
        if (lookAndFeel != null) {
            Application.getUserPreferences().put(DEFAULT_LAF_KEY, lookAndFeel.getClass().getName());
        }
    }

    public static void setDefaultLookConfiguration(LookConfiguration lookConfiguration) {
        ExtUIManager.setDefaultLookAndFeel(lookConfiguration.getLookAndFeel());
    }

    public static LookAndFeel createLookAndFeelInstance(String string) {
        String string2 = Options.getReplacementClassNameFor((String)string);
        try {
            Class<?> clazz = Class.forName(string2);
            return (LookAndFeel)clazz.newInstance();
        }
        catch (Throwable throwable) {
            String string3 = "Class name=" + string + "\nReplacement class name=" + string2;
            LOGGER.log(Level.WARNING, string3, throwable);
            return null;
        }
    }

    public static List lookupSupportedLookAndFeelInstances() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        ArrayList<LookAndFeel> arrayList = new ArrayList<LookAndFeel>(lookAndFeelInfoArray.length);
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            String string = lookAndFeelInfoArray[i].getClassName();
            LookAndFeel lookAndFeel = ExtUIManager.createLookAndFeelInstance(string);
            if (lookAndFeel == null || !lookAndFeel.isSupportedLookAndFeel()) continue;
            arrayList.add(lookAndFeel);
        }
        return arrayList;
    }

    private static void setLookAndTheme(LookConfiguration lookConfiguration) {
        ExtUIManager.setLookAndTheme(lookConfiguration.getLookAndFeel(), lookConfiguration.getTheme());
    }

    private static void setLookAndTheme(LookAndFeel lookAndFeel, Object object) {
        try {
            LOGGER.info("Setting L&F: " + lookAndFeel.getName());
            LookUtils.setLookAndTheme((LookAndFeel)lookAndFeel, (Object)object);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            LOGGER.warning("Can't set unsupported look and feel:" + lookAndFeel.getName());
        }
    }

    public static List getSupportedLookAndFeelInstances() {
        if (supportedLafs == null) {
            supportedLafs = ExtUIManager.lookupSupportedLookAndFeelInstances();
            Collections.sort(supportedLafs, new LafNameComparator());
        }
        return supportedLafs;
    }

    private static class LafNameComparator
    implements Comparator {
        private LafNameComparator() {
        }

        public int compare(Object object, Object object2) {
            LookAndFeel lookAndFeel = (LookAndFeel)object;
            LookAndFeel lookAndFeel2 = (LookAndFeel)object2;
            return lookAndFeel.getName().toUpperCase().compareTo(lookAndFeel2.getName().toUpperCase());
        }
    }
}

