/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.laf;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.uif.laf.LookChoiceStrategy;

public final class LookChoiceStrategies {
    public static final LookChoiceStrategy DEFAULT = new DefaultStrategy();
    public static final LookChoiceStrategy SYSTEM = new SystemStrategy();
    public static final LookChoiceStrategy FIXED_3D = new Fixed3DStrategy();
    public static final LookChoiceStrategy FIXED_XP = new FixedXPStrategy();
    public static final LookChoiceStrategy FIXED = FIXED_3D;

    private LookChoiceStrategies() {
    }

    private static class DefaultStrategy
    implements LookChoiceStrategy {
        private DefaultStrategy() {
        }

        public String getDefaultLookClassName() {
            return LookUtils.IS_OS_WINDOWS_XP ? "com.jgoodies.looks.plastic.PlasticXPLookAndFeel" : Options.getSystemLookAndFeelClassName();
        }
    }

    private static class SystemStrategy
    implements LookChoiceStrategy {
        private SystemStrategy() {
        }

        public String getDefaultLookClassName() {
            return Options.getSystemLookAndFeelClassName();
        }
    }

    private static class FixedXPStrategy
    implements LookChoiceStrategy {
        private FixedXPStrategy() {
        }

        public String getDefaultLookClassName() {
            return "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
        }
    }

    private static class Fixed3DStrategy
    implements LookChoiceStrategy {
        private Fixed3DStrategy() {
        }

        public String getDefaultLookClassName() {
            return "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
        }
    }
}

