/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.laf;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.LookAndFeel;

public final class LookConfiguration
extends Model
implements Cloneable {
    public static final String PROPERTYNAME_THEME = "theme";
    public static final String PROPERTYNAME_THEMES = "themes";
    private static final String THEME_KEY_PREFIX = "laf.themeName.";
    private static final Logger LOGGER = Logger.getLogger("LookConfiguration");
    private static final List PLASTIC_THEMES = Collections.unmodifiableList(PlasticLookAndFeel.getInstalledThemes());
    private static final List NO_THEMES = Collections.EMPTY_LIST;
    private final LookAndFeel laf;
    private Object theme;

    public LookConfiguration(LookAndFeel lookAndFeel) {
        this(lookAndFeel, null);
    }

    public LookConfiguration(LookAndFeel lookAndFeel, Object object) {
        if (lookAndFeel == null) {
            throw new NullPointerException("LookAndFeel must not be null.");
        }
        this.laf = lookAndFeel;
        this.theme = object != null ? object : LookUtils.getDefaultTheme((LookAndFeel)lookAndFeel);
    }

    static LookConfiguration restoreFrom(LookAndFeel lookAndFeel, Preferences preferences) {
        return new LookConfiguration(lookAndFeel, LookConfiguration.restoreThemeFrom(lookAndFeel, preferences));
    }

    public LookAndFeel getLookAndFeel() {
        return this.laf;
    }

    public List getThemes() {
        return this.laf instanceof PlasticLookAndFeel ? PLASTIC_THEMES : NO_THEMES;
    }

    public Object getTheme() {
        return this.theme;
    }

    public void setTheme(Object object) {
        Object object2 = this.getTheme();
        this.theme = object;
        this.firePropertyChange(PROPERTYNAME_THEME, object2, object);
    }

    void storeIn(Preferences preferences) {
        LOGGER.config("Storing the LookConfiguration for " + this.laf);
        if (this.getTheme() != null) {
            preferences.put(LookConfiguration.themeKey(this.laf), this.theme.getClass().getName());
        }
    }

    private static Object restoreThemeFrom(LookAndFeel lookAndFeel, Preferences preferences) {
        String string = preferences.get(LookConfiguration.themeKey(lookAndFeel), null);
        if (string != null) {
            LOGGER.config("Restoring theme for " + lookAndFeel.getName() + ": " + string);
        }
        return string == null ? null : LookConfiguration.createThemeInstance(string);
    }

    private static Object createThemeInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Class name=" + string, exception);
            return null;
        }
    }

    private static String themeKey(LookAndFeel lookAndFeel) {
        return THEME_KEY_PREFIX + lookAndFeel.getName();
    }

    private String getLafClassName() {
        return this.laf.getClass().getName();
    }

    public Object clone() {
        return new LookConfiguration(this.getLookAndFeel(), this.getTheme());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LookConfiguration)) {
            return false;
        }
        LookConfiguration lookConfiguration = (LookConfiguration)object;
        return this.getLafClassName().equals(lookConfiguration.getLafClassName()) && (this.theme == null && lookConfiguration.theme == null || this.theme != null && this.theme.equals(lookConfiguration.theme));
    }

    public int hashCode() {
        return this.laf.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("lafName=");
        stringBuffer.append(this.getLookAndFeel().getName());
        if (this.getTheme() != null) {
            stringBuffer.append("; theme=");
            stringBuffer.append(this.getTheme().getClass().getName());
        }
        return stringBuffer.toString();
    }
}

