/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.laf;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.uif.laf.ExtUIManager;
import com.jgoodies.uif.laf.LookConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.LookAndFeel;

public final class LookConfigurations
extends Model
implements Cloneable {
    public static final String PROPERTYNAME_CONFIGURATIONS = "configurations";
    public static final String PROPERTYNAME_DEFAULT_CONFIGURATION = "defaultConfiguration";
    private final Map configurations = new HashMap();
    private LookConfiguration defaultConfiguration;

    public LookConfigurations(LookConfiguration lookConfiguration) {
        this.defaultConfiguration = lookConfiguration;
    }

    static LookConfigurations restoreFrom(Preferences preferences) {
        LookConfiguration lookConfiguration = ExtUIManager.getDefaultLookConfiguration();
        LookConfigurations lookConfigurations = new LookConfigurations(lookConfiguration);
        Iterator iterator = ExtUIManager.getSupportedLookAndFeelInstances().iterator();
        while (iterator.hasNext()) {
            LookAndFeel lookAndFeel = (LookAndFeel)iterator.next();
            lookConfigurations.putConfiguration(LookConfiguration.restoreFrom(lookAndFeel, preferences));
        }
        return lookConfigurations;
    }

    public LookConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public void setDefaultConfiguration(LookConfiguration lookConfiguration) {
        LookConfiguration lookConfiguration2 = this.getDefaultConfiguration();
        this.defaultConfiguration = lookConfiguration;
        this.firePropertyChange(PROPERTYNAME_DEFAULT_CONFIGURATION, lookConfiguration2, lookConfiguration);
    }

    public Collection getConfigurations() {
        ArrayList arrayList = new ArrayList(this.configurations.values());
        Collections.sort(arrayList, new ConfigurationComparator());
        return arrayList;
    }

    private LookConfiguration getConfiguration(LookAndFeel lookAndFeel) {
        LookConfiguration lookConfiguration = (LookConfiguration)this.configurations.get(this.getKey(lookAndFeel));
        return lookConfiguration != null ? lookConfiguration : new LookConfiguration(lookAndFeel);
    }

    private void putConfiguration(LookConfiguration lookConfiguration) {
        this.configurations.put(this.getKey(lookConfiguration), lookConfiguration);
    }

    private String getKey(LookConfiguration lookConfiguration) {
        return this.getKey(lookConfiguration.getLookAndFeel());
    }

    private String getKey(LookAndFeel lookAndFeel) {
        return lookAndFeel.getClass().getName();
    }

    void storeIn(Preferences preferences) {
        ExtUIManager.setDefaultLookConfiguration(this.getDefaultConfiguration());
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            LookConfiguration lookConfiguration = (LookConfiguration)iterator.next();
            lookConfiguration.storeIn(preferences);
        }
    }

    public Object clone() {
        LookConfiguration lookConfiguration = (LookConfiguration)this.defaultConfiguration.clone();
        LookConfigurations lookConfigurations = new LookConfigurations(lookConfiguration);
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            LookConfiguration lookConfiguration2 = (LookConfiguration)iterator.next();
            lookConfigurations.putConfiguration(lookConfiguration2.equals(lookConfiguration) ? lookConfiguration : (LookConfiguration)lookConfiguration2.clone());
        }
        return lookConfigurations;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LookConfigurations)) {
            return false;
        }
        LookConfigurations lookConfigurations = (LookConfigurations)object;
        if (!this.getDefaultConfiguration().equals(lookConfigurations.getDefaultConfiguration())) {
            return false;
        }
        Iterator iterator = this.configurations.values().iterator();
        while (iterator.hasNext()) {
            LookConfiguration lookConfiguration = (LookConfiguration)iterator.next();
            LookConfiguration lookConfiguration2 = lookConfigurations.getConfiguration(lookConfiguration.getLookAndFeel());
            if (lookConfiguration2 != null && lookConfiguration.equals(lookConfiguration2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.defaultConfiguration.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LookConfigurations[");
        stringBuffer.append("\n    default=");
        stringBuffer.append(this.getDefaultConfiguration().toString());
        Iterator iterator = this.getConfigurations().iterator();
        while (iterator.hasNext()) {
            LookConfiguration lookConfiguration = (LookConfiguration)iterator.next();
            stringBuffer.append("\n    ");
            stringBuffer.append(lookConfiguration.toString());
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }

    private static class ConfigurationComparator
    implements Comparator {
        private ConfigurationComparator() {
        }

        public int compare(Object object, Object object2) {
            LookConfiguration lookConfiguration = (LookConfiguration)object;
            LookConfiguration lookConfiguration2 = (LookConfiguration)object2;
            return lookConfiguration.getLookAndFeel().getName().toUpperCase().compareTo(lookConfiguration2.getLookAndFeel().getName().toUpperCase());
        }
    }
}

