/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.lazy;

import com.jgoodies.uif.lazy.Preparable;
import java.util.logging.Logger;

public final class BackgroundClassLoader
implements Preparable {
    private final String[] classNames;

    public BackgroundClassLoader(String[] stringArray) {
        this.classNames = stringArray;
    }

    public void prepare() {
        Logger logger = Logger.getLogger("BackgroundClassLoader");
        logger.info("Loading " + this.classNames.length + " classes\u2026");
        long l = System.currentTimeMillis();
        for (int i = 0; i < this.classNames.length; ++i) {
            try {
                Class.forName(this.classNames[i]);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.info("Class not found: " + this.classNames[i]);
            }
        }
        long l2 = System.currentTimeMillis();
        logger.info("Loaded in " + (l2 - l) + "ms.");
    }
}

