/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.lazy;

import com.jgoodies.uif.lazy.Preparable;
import com.jgoodies.uif.util.SystemUtils;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BackgroundLoader
extends Thread
implements Preparable {
    private static final int DEFAULT_DELAY_MS = 1500;
    private static final int DEFAULT_PRIORITY = 4;
    private final Vector preparables = new Vector();
    private long delayMilliseconds;

    public BackgroundLoader() {
        this(1500L);
    }

    public BackgroundLoader(long l) {
        this(l, 4);
    }

    public BackgroundLoader(long l, int n) {
        this.delayMilliseconds = l;
        this.setPriority(n);
    }

    public void add(Preparable preparable) {
        this.preparables.add(preparable);
    }

    public void prepare() {
        Enumeration enumeration = this.preparables.elements();
        while (enumeration.hasMoreElements()) {
            Preparable preparable = (Preparable)enumeration.nextElement();
            try {
                preparable.prepare();
            }
            catch (Throwable throwable) {
                Logger.getLogger("BackgroundLoader").log(Level.WARNING, "Could not prepare " + preparable, throwable);
            }
        }
    }

    public void run() {
        SystemUtils.sleep(this.delayMilliseconds);
        this.prepare();
    }
}

