/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.lazy;

import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.JPanel;

public abstract class LazyBuildingPanel
extends JPanel {
    private boolean hasBeenBuilt = false;
    private boolean isBuilding = false;

    public LazyBuildingPanel() {
    }

    public LazyBuildingPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public final synchronized void ensureBuilt() {
        if (this.hasBeenBuilt) {
            return;
        }
        if (this.isBuilding) {
            this.getLogger().warning("Don't call #ensureBuilt while the panel is building.");
            return;
        }
        this.isBuilding = true;
        this.getLogger().info("Building panel");
        this.build();
        this.hasBeenBuilt = true;
        this.isBuilding = false;
    }

    protected abstract void build();

    public boolean hasBeenBuilt() {
        return this.hasBeenBuilt;
    }

    private Logger getLogger() {
        return Logger.getLogger(this.getClass().getName());
    }
}

