/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.lazy;

import com.jgoodies.uif.action.ActionManager;
import com.jgoodies.uif.laf.ExtUIManager;
import com.jgoodies.uif.lazy.BackgroundClassLoader;
import com.jgoodies.uif.lazy.Preparable;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public final class Preparables {
    private Preparables() {
    }

    public static Preparable createEagerActionReader() {
        return new EagerActionReader();
    }

    public static Preparable createMenuInitializer() {
        return new MenuPreparer();
    }

    public static Preparable createSupportedLafsReader() {
        return new EagerSupportedLafsReader();
    }

    public static Preparable createUIDefaultsInitializer() {
        return new EagerUIDefaultsInitializer();
    }

    private static class MenuPreparer
    implements Preparable {
        private MenuPreparer() {
        }

        public void prepare() {
            new BackgroundClassLoader(new String[]{"javax.swing.JMenuBar", "javax.swing.JMenu", "javax.swing.JMenuItem", "javax.swing.plaf.basic.BasicMenuBarUI", "javax.swing.plaf.basic.BasicMenuUI", "javax.swing.plaf.basic.BasicMenuItemUI"}).prepare();
        }
    }

    private static class EagerUIDefaultsInitializer
    implements Preparable {
        private EagerUIDefaultsInitializer() {
        }

        public void prepare() {
            Logger logger = Logger.getLogger("EagerUIDefaultInitializer");
            logger.info("Activating all lazy UI values...");
            long l = System.currentTimeMillis();
            int n = this.activateLazyValues();
            long l2 = System.currentTimeMillis();
            logger.info("Activated " + n + " UI values in " + (l2 - l) + "ms.");
        }

        private int activateLazyValues() {
            UIDefaults uIDefaults = UIManager.getDefaults();
            UIDefaults uIDefaults2 = UIManager.getLookAndFeelDefaults();
            int n = 0;
            Enumeration enumeration = uIDefaults.keys();
            while (enumeration.hasMoreElements()) {
                uIDefaults.get(enumeration.nextElement());
                ++n;
            }
            enumeration = uIDefaults2.keys();
            while (enumeration.hasMoreElements()) {
                uIDefaults.get(enumeration.nextElement());
                ++n;
            }
            return n;
        }
    }

    private static class EagerSupportedLafsReader
    implements Preparable {
        private EagerSupportedLafsReader() {
        }

        public void prepare() {
            Logger.getLogger("EagerSupportedLafsReader").info("Computing supported look and feels...");
            ExtUIManager.getSupportedLookAndFeelInstances();
        }
    }

    private static class EagerActionReader
    implements Preparable {
        private EagerActionReader() {
        }

        public void prepare() {
            Logger logger = Logger.getLogger("EagerActionReader");
            logger.info("Reading all lazy actions registered with the ActionManager\u2026");
            ActionManager.ensureAllActionsRead();
        }
    }
}

