/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.osx;

import com.jgoodies.uif.util.SystemUtils;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.logging.Logger;

public final class OSXApplicationMenu {
    private static final String KEY_MAC_APPLICATION_MENU_ABOUT_NAME = "com.apple.mrj.application.apple.menu.about.name";
    private static final String OSX_APPLICATION_HANDLER_CLASSNAME = "com.jgoodies.uif.osx.OSXApplicationHandler";
    static ActionListener aboutListener;
    static ActionListener prefsListener;
    static ActionListener quitListener;
    private static boolean registered;
    static /* synthetic */ Class class$com$jgoodies$uif$osx$OSXApplicationMenu;

    private OSXApplicationMenu() {
    }

    public static void setAboutName(String string) {
        try {
            System.setProperty(KEY_MAC_APPLICATION_MENU_ABOUT_NAME, string);
        }
        catch (AccessControlException accessControlException) {
            Logger.getLogger((class$com$jgoodies$uif$osx$OSXApplicationMenu == null ? (class$com$jgoodies$uif$osx$OSXApplicationMenu = OSXApplicationMenu.class$("com.jgoodies.uif.osx.OSXApplicationMenu")) : class$com$jgoodies$uif$osx$OSXApplicationMenu).getName()).warning("Can set the OS X application menu name only in trusted environments.");
        }
    }

    public static synchronized boolean register(ActionListener actionListener, ActionListener actionListener2, ActionListener actionListener3) {
        if (actionListener == null && actionListener2 == null && actionListener3 == null) {
            return false;
        }
        aboutListener = actionListener;
        prefsListener = actionListener2;
        quitListener = actionListener3;
        registered = OSXApplicationMenu.lookupAndRegister();
        return registered;
    }

    public static boolean isRegisteredAbout() {
        return registered && aboutListener != null;
    }

    public static boolean isRegisteredPreferences() {
        return registered && prefsListener != null;
    }

    public static boolean isRegisteredQuit() {
        return registered && quitListener != null;
    }

    private static boolean lookupAndRegister() {
        Class<?> clazz;
        if (!SystemUtils.IS_OS_MAC) {
            return false;
        }
        try {
            clazz = Class.forName(OSX_APPLICATION_HANDLER_CLASSNAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found OSXApplicationHandler");
            return false;
        }
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        try {
            Method method = clazz.getDeclaredMethod("register", classArray);
            method.invoke(clazz, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        registered = false;
    }
}

