/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.splash;

import com.jgoodies.uif.splash.SplashProvider;
import com.jgoodies.uif.util.ScreenUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;

public final class ImageSplash
extends Window
implements SplashProvider {
    private static final int DEFAULT_BAR_WIDTH = 100;
    private static final int DEFAULT_BAR_HEIGHT = 10;
    private static final int VPAD = 10;
    private final Image image;
    private String note;
    private boolean noteEnabled;
    private boolean progressVisible;
    private Color textColor;
    private Rectangle progressBarBounds;
    private int percent;

    public ImageSplash(Image image) {
        this(image, false);
    }

    public ImageSplash(Image image, boolean bl) {
        this(new Frame(), image, "Loading\u2026", bl);
    }

    public ImageSplash(Frame frame, Image image, String string, boolean bl) {
        super(frame);
        this.image = image;
        this.note = string;
        this.percent = 0;
        this.progressVisible = bl;
        this.setSize(image.getWidth(null), image.getHeight(null));
        this.setProgressBarBounds(10);
        this.setForeground(Color.DARK_GRAY);
        this.setBackground(Color.LIGHT_GRAY);
        this.textColor = Color.BLACK;
        ScreenUtils.locateOnScreenCenter(this);
    }

    public boolean isNoteEnabled() {
        return this.noteEnabled;
    }

    public void setNoteEnabled(boolean bl) {
        this.noteEnabled = bl;
    }

    public boolean isProgressVisible() {
        return this.progressVisible;
    }

    public void setProgressVisible(boolean bl) {
        this.progressVisible = bl;
    }

    public boolean isShowingProgress() {
        return this.isProgressVisible();
    }

    public void setShowingProgress(boolean bl) {
        this.setProgressVisible(bl);
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public void setProgressBarBounds(Rectangle rectangle) {
        this.progressBarBounds = new Rectangle(rectangle);
    }

    public void setProgressBarBounds(int n) {
        this.setProgressBarBounds(this.defaultProgressBarBounds(n));
    }

    private Rectangle defaultProgressBarBounds(int n) {
        int n2 = (this.getWidth() - 100) / 2;
        int n3 = this.getHeight() - 10 - n;
        return new Rectangle(n2, n3, 100, 10);
    }

    public void paint(Graphics graphics) {
        boolean bl = this.progressBarBounds.equals(graphics.getClipBounds());
        if (!(this.image == null || this.progressVisible && bl)) {
            graphics.drawImage(this.image, 0, 0, this);
        }
        if (this.progressVisible) {
            int n = this.progressBarBounds.x;
            int n2 = this.progressBarBounds.y;
            int n3 = this.progressBarBounds.width;
            int n4 = this.progressBarBounds.height;
            int n5 = (n3 - 2) * this.percent / 100;
            int n6 = n4 - 2;
            graphics.translate(n, n2);
            graphics.setColor(Color.GRAY);
            graphics.drawLine(0, 0, n3 - 2, 0);
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            graphics.setColor(this.getBackground());
            graphics.fillRect(1, 1, n3 - 2, n6);
            graphics.setColor(this.getForeground());
            graphics.fillRect(1, 1, n5, n6);
            graphics.translate(-n, -n2);
            if (!bl) {
                FontMetrics fontMetrics = this.getFontMetrics(graphics.getFont());
                int n7 = fontMetrics.stringWidth(this.note);
                int n8 = (this.getWidth() - n7) / 2;
                graphics.setColor(this.textColor);
                graphics.drawString(this.note, n8, this.progressBarBounds.y - 5);
            }
        }
    }

    public void openSplash() {
        this.setVisible(true);
    }

    public void closeSplash() {
        this.dispose();
    }

    public void setProgress(int n) {
        if (!this.progressVisible) {
            return;
        }
        this.percent = n;
        this.repaint(this.progressBarBounds.x, this.progressBarBounds.y, this.progressBarBounds.width, this.progressBarBounds.height);
    }

    public void setNote(String string) {
        if (this.isNoteEnabled()) {
            this.note = string;
            this.repaint();
        }
    }
}

