/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.splash;

import com.jgoodies.uif.splash.SplashProvider;
import java.util.logging.Logger;

public final class Splash {
    private static final Logger LOGGER = Logger.getLogger("Splash");
    private static SplashProvider provider;
    private static long t0;
    private static boolean splashOpen;

    private Splash() {
    }

    public static void resetStartTime() {
        t0 = System.currentTimeMillis();
    }

    public static long elapsedTime() {
        return System.currentTimeMillis() - t0;
    }

    public static synchronized void ensureOpen() {
        if (!splashOpen) {
            Splash.open();
        }
    }

    public static synchronized void ensureClosed() {
        if (splashOpen) {
            Splash.close();
        }
    }

    public static synchronized void open() {
        if (splashOpen) {
            throw new IllegalStateException("Splash is already open.");
        }
        Splash.getProvider().openSplash();
        splashOpen = true;
        LOGGER.config(Splash.elapsedTime() + "ms - opened");
    }

    public static synchronized void close() {
        if (!splashOpen) {
            throw new IllegalStateException("Splash has been closed before.");
        }
        LOGGER.config(Splash.elapsedTime() + "ms - closed");
        Splash.getProvider().closeSplash();
        splashOpen = false;
    }

    public static void setNote(String string) {
        LOGGER.config(Splash.elapsedTime() + "ms - " + string);
        Splash.getProvider().setNote(string);
    }

    public static void setProgress(int n) {
        LOGGER.config(Splash.elapsedTime() + "ms " + n + "%");
        Splash.getProvider().setProgress(n);
    }

    public static void setNote(String string, int n) {
        Splash.setNote(string);
        Splash.setProgress(n);
    }

    public static SplashProvider getProvider() {
        if (provider == null) {
            provider = new NullSplash();
        }
        return provider;
    }

    public static void setProvider(SplashProvider splashProvider) {
        provider = splashProvider;
    }

    static {
        t0 = System.currentTimeMillis();
        splashOpen = false;
    }

    private static class NullSplash
    implements SplashProvider {
        private NullSplash() {
        }

        public void openSplash() {
        }

        public void closeSplash() {
        }

        public void setNote(String string) {
        }

        public void setProgress(int n) {
        }
    }
}

