/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.util;

import com.jgoodies.uif.util.Mode;
import com.jgoodies.uif.util.SystemUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public final class Modes
implements Mode,
Serializable {
    public static final Modes ALWAYS = new Modes("Always");
    public static final Modes NEVER = new Modes("Never");
    public static final Modes LAF_AQUA = new Modes("Aqua l&f only");
    public static final Modes LAF_WINDOWS = new Modes("Windows l&f only");
    public static final Modes LAF_NON_AQUA = new Modes("No Aqua l&f");
    public static final Modes LAF_NON_WINDOWS = new Modes("No Windows l&f");
    public static final Modes OS_MAC = new Modes("Mac OS only");
    public static final Modes OS_WINDOWS = new Modes("Windows OS Only");
    public static final Modes OS_NON_MAC = new Modes("No Mac OS");
    public static final Modes OS_NON_WINDOWS = new Modes("No Windows OS");
    public static final Modes OS_LINUX = new Modes("Linux only");
    public static final Modes OS_NON_LINUX = new Modes("No Linux");
    private final transient String name;
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    private static final Modes[] VALUES = new Modes[]{ALWAYS, NEVER, LAF_AQUA, LAF_WINDOWS, LAF_NON_AQUA, LAF_NON_WINDOWS, OS_MAC, OS_WINDOWS, OS_NON_MAC, OS_NON_WINDOWS, OS_LINUX, OS_NON_LINUX};
    private static Boolean cachedIsLafAqua;
    private static Boolean cachedIsLafWindows;
    private static boolean changeHandlerRegistered;

    private Modes(String string) {
        this.name = string;
    }

    public boolean enabled() {
        if (this == ALWAYS) {
            return true;
        }
        if (this == NEVER) {
            return false;
        }
        if (this == OS_LINUX) {
            return SystemUtils.IS_OS_LINUX;
        }
        if (this == OS_MAC) {
            return SystemUtils.IS_OS_MAC;
        }
        if (this == OS_WINDOWS) {
            return SystemUtils.IS_OS_WINDOWS;
        }
        if (this == OS_NON_LINUX) {
            return !SystemUtils.IS_OS_LINUX;
        }
        if (this == OS_NON_MAC) {
            return !SystemUtils.IS_OS_MAC;
        }
        if (this == OS_NON_WINDOWS) {
            return !SystemUtils.IS_OS_WINDOWS;
        }
        if (this == LAF_AQUA) {
            return Modes.isLafAqua();
        }
        if (this == LAF_WINDOWS) {
            return Modes.isLafWindows();
        }
        if (this == LAF_NON_AQUA) {
            return !Modes.isLafAqua();
        }
        if (this == LAF_NON_WINDOWS) {
            return !Modes.isLafWindows();
        }
        throw new IllegalStateException("Unknown mode");
    }

    public String toString() {
        return "Mode: " + this.name + " currently " + (this.enabled() ? "enabled" : "disabled");
    }

    private Object readResolve() {
        return VALUES[this.ordinal];
    }

    private static void ensureLookAndFeelChangeHandlerRegistered() {
        if (!changeHandlerRegistered) {
            UIManager.addPropertyChangeListener(new LookAndFeelChangeHandler());
            changeHandlerRegistered = true;
        }
    }

    public static boolean isLafAqua() {
        if (cachedIsLafAqua == null) {
            cachedIsLafAqua = Modes.computeIsLafAqua();
            Modes.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafAqua;
    }

    public static boolean isLafWindows() {
        if (cachedIsLafWindows == null) {
            cachedIsLafWindows = Modes.computeIsLafWindows();
            Modes.ensureLookAndFeelChangeHandlerRegistered();
        }
        return cachedIsLafWindows;
    }

    private static boolean computeIsLafAqua() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return lookAndFeel.getName().startsWith("Mac OS X Aqua");
    }

    private static boolean computeIsLafWindows() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        return SystemUtils.IS_OS_WINDOWS && lookAndFeel instanceof WindowsLookAndFeel;
    }

    static {
        changeHandlerRegistered = false;
    }

    private static class LookAndFeelChangeHandler
    implements PropertyChangeListener {
        private LookAndFeelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            cachedIsLafAqua = null;
            cachedIsLafWindows = null;
        }
    }
}

