/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.util;

import java.awt.Dimension;
import javax.swing.JComponent;

public final class Resizer {
    private static final float SQRT_RATIO = 1.0f / (float)Math.sqrt(2.0);
    private static final int HORIZONTAL_DIALOG_MARGIN = 6;
    private static final int VERTICAL_DIALOG_MARGIN = 25;
    public static final Resizer ONE2ONE = new Resizer(1.0f);
    public static final Resizer FIVE2FOUR = new Resizer(1.25f);
    public static final Resizer FOUR2THREE;
    public static final Resizer DEFAULT;
    public static final Resizer SQRT;
    public static final Resizer REVERSE_SQRT;
    private final float aspectRatio;

    public Resizer(float f) {
        this.aspectRatio = f;
    }

    public Dimension from(Dimension dimension) {
        return this.from(dimension, 0, 0);
    }

    public Dimension from(Dimension dimension, int n, int n2) {
        int n3 = dimension.width + n;
        int n4 = dimension.height + n2;
        int n5 = Math.round((float)n4 * this.aspectRatio);
        int n6 = Math.round((float)n3 / this.aspectRatio);
        return n3 < n5 ? new Dimension(n5 - n, n4 - n2) : new Dimension(n3 - n, n6 - n2);
    }

    public Dimension fromHeight(int n) {
        return new Dimension(Math.round((float)n * this.aspectRatio), n);
    }

    public Dimension fromWidth(int n) {
        return new Dimension(n, Math.round((float)n / this.aspectRatio));
    }

    public void resize(JComponent jComponent) {
        jComponent.setPreferredSize(this.from(jComponent.getPreferredSize()));
    }

    public void resizeDialogContent(JComponent jComponent) {
        jComponent.setPreferredSize(this.from(jComponent.getPreferredSize(), 6, 25));
    }

    static {
        DEFAULT = FOUR2THREE = new Resizer(1.3333334f);
        SQRT = new Resizer(SQRT_RATIO);
        REVERSE_SQRT = new Resizer(1.0f / SQRT_RATIO);
    }
}

