/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.util;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public final class ResourceUtils {
    private static final ResourceUtils INSTANCE = new ResourceUtils();
    private static final Logger LOGGER = Logger.getLogger("ResourceUtils");
    private ResourceBundle bundle;
    private ClassLoader defaultClassLoader = (class$com$jgoodies$uif$util$ResourceUtils == null ? (class$com$jgoodies$uif$util$ResourceUtils = ResourceUtils.class$("com.jgoodies.uif.util.ResourceUtils")) : class$com$jgoodies$uif$util$ResourceUtils).getClassLoader();
    static /* synthetic */ Class class$com$jgoodies$uif$util$ResourceUtils;

    private ResourceUtils() {
    }

    public static void setBundlePath(String string) {
        ResourceUtils.setBundle(ResourceBundle.getBundle(string, Locale.getDefault(), ResourceUtils.INSTANCE.defaultClassLoader));
    }

    public static void setBundle(ResourceBundle resourceBundle) {
        ResourceUtils.INSTANCE.bundle = resourceBundle;
    }

    public static ResourceBundle getBundle() {
        return ResourceUtils.INSTANCE.bundle;
    }

    public static ClassLoader getDefaultClassLoader() {
        return ResourceUtils.INSTANCE.defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader classLoader) {
        ResourceUtils.INSTANCE.defaultClassLoader = classLoader;
    }

    public static String getString(String string) {
        try {
            return ResourceUtils.INSTANCE.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            LOGGER.warning("Missing resource for key:" + string);
            return null;
        }
    }

    public static String getString(String string, String string2) {
        try {
            return ResourceUtils.INSTANCE.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public static ImageIcon getIcon(String string) {
        String string2 = ResourceUtils.getString(string);
        if (string2 == null) {
            return null;
        }
        if (string2.length() == 0) {
            LOGGER.warning(string + " has an empty path.");
            return null;
        }
        return ResourceUtils.readImageIcon(string2);
    }

    public static InputStream getInputStream(String string) {
        URL uRL = ResourceUtils.getURL(string);
        if (uRL != null) {
            try {
                return uRL.openStream();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Can't open URL " + uRL.toString(), iOException);
            }
        }
        return null;
    }

    public static URL getURL(String string) {
        return ResourceUtils.getURL(string, ResourceUtils.INSTANCE.defaultClassLoader);
    }

    public static URL getURL(String string, ClassLoader classLoader) {
        URL uRL = classLoader.getResource(string);
        if (null == uRL) {
            LOGGER.warning(string + " not found.");
        }
        return uRL;
    }

    public static Image readImage(String string) {
        URL uRL = ResourceUtils.getURL(string);
        if (uRL == null) {
            return null;
        }
        try {
            return ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ImageIcon readImageIcon(String string) {
        URL uRL = ResourceUtils.getURL(string);
        return null == uRL ? null : new ImageIcon(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readTextFromFile(String var0) {
        block19: {
            block18: {
                var1_1 = null;
                try {
                    var1_1 = ResourceUtils.getInputStream(var0);
                    if (null == var1_1) {
                        var2_2 = null;
                        var11_4 = null;
                        if (var1_1 == null) return var2_2;
                        break block18;
                    }
                    var2_3 = new StringBuffer();
                    var3_12 = new InputStreamReader(var1_1);
                    var4_13 = new BufferedReader(var3_12);
                    try {
                        var5_14 = var4_13.readLine();
                        while (var5_14 != null) {
                            var2_3.append(var5_14);
                            var5_14 = var4_13.readLine();
                            if (var5_14 == null) continue;
                            var2_3.append('\n');
                        }
                        var6_16 = var2_3.toString();
                        var8_18 = null;
                        ** GOTO lbl-1000
                    }
                    catch (IOException var5_15) {
                        block20: {
                            try {
                                ResourceUtils.LOGGER.log(Level.WARNING, "Can't read string from " + var0, var5_15);
                                var6_17 = null;
                                var8_19 = null;
                            }
                            catch (Throwable var7_24) {
                                var8_20 = null;
                                try {
                                    var4_13.close();
                                    throw var7_24;
                                }
                                catch (IOException var9_23) {
                                    ResourceUtils.LOGGER.log(Level.WARNING, "Could not close the text file reader.", var9_23);
                                }
                                throw var7_24;
                            }
lbl-1000:
                            // 1 sources

                            try {}
                            catch (IOException var9_21) {
                                ResourceUtils.LOGGER.log(Level.WARNING, "Could not close the text file reader.", var9_21);
                                break block19;
                            }
                            var4_13.close();
                            break block19;
                            ** try [egrp 3[TRYBLOCK] [4 : 156->164)] { 
lbl51:
                            // 1 sources

                            var4_13.close();
                            break block20;
lbl53:
                            // 1 sources

                            catch (IOException var9_22) {
                                ResourceUtils.LOGGER.log(Level.WARNING, "Could not close the text file reader.", var9_22);
                            }
                        }
                        var11_6 = null;
                        if (var1_1 == null) return var6_17;
                        try {
                            var1_1.close();
                            return var6_17;
                        }
                        catch (IOException var12_10) {
                            ResourceUtils.LOGGER.log(Level.WARNING, "Could not close the input stream.", var12_10);
                        }
                        return var6_17;
                    }
                }
                catch (Throwable var10_25) {
                    var11_7 = null;
                    if (var1_1 == null) throw var10_25;
                    try {}
                    catch (IOException var12_11) {
                        ResourceUtils.LOGGER.log(Level.WARNING, "Could not close the input stream.", var12_11);
                        throw var10_25;
                    }
                    var1_1.close();
                    throw var10_25;
                }
            }
            ** try [egrp 4[TRYBLOCK] [9 : 195->202)] { 
lbl77:
            // 1 sources

            var1_1.close();
            return var2_2;
lbl79:
            // 1 sources

            catch (IOException var12_8) {
                ResourceUtils.LOGGER.log(Level.WARNING, "Could not close the input stream.", var12_8);
            }
            return var2_2;
        }
        var11_5 = null;
        if (var1_1 == null) return var6_16;
        try {}
        catch (IOException var12_9) {
            ResourceUtils.LOGGER.log(Level.WARNING, "Could not close the input stream.", var12_9);
            return var6_16;
        }
        var1_1.close();
        return var6_16;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

