/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

public final class ScreenUtils {
    private ScreenUtils() {
    }

    public static void locateOnScreenCenter(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component.getToolkit().getScreenSize();
        component.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
    }

    public static void locateOnScreenNorthEast(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component.getToolkit().getScreenSize();
        component.setLocation(dimension2.width - dimension.width, 0);
    }

    public static void locateOnScreenWest(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component.getToolkit().getScreenSize();
        component.setLocation(0, (dimension2.height - dimension.height) / 2);
    }

    public static void locateOnScreenEast(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = component.getToolkit().getScreenSize();
        component.setLocation(dimension2.width - dimension.width, (dimension2.height - dimension.height) / 2);
    }

    public static boolean has1024x768Screen() {
        Dimension dimension = ScreenUtils.screenSize();
        return dimension.width >= 1024 && dimension.height >= 768;
    }

    public static boolean has800x600Screen() {
        Dimension dimension = ScreenUtils.screenSize();
        return dimension.width >= 800 && dimension.height >= 600;
    }

    public static String encodedScreenConfiguration(Toolkit toolkit) {
        Dimension dimension = toolkit.getScreenSize();
        String string = Integer.toString(dimension.width) + 'x' + dimension.height;
        int n = ScreenUtils.screenCount();
        return n == 1 ? string : string + '.' + n;
    }

    private static int screenCount() {
        int n = 0;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        for (int i = 0; i < graphicsDeviceArray.length; ++i) {
            if (graphicsDeviceArray[i].getType() != 0) continue;
            ++n;
        }
        return n;
    }

    private static Dimension screenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }
}

