/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.util;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;

public final class SystemUtils {
    private static final String OS_NAME = SystemUtils.getSystemProperty("os.name");
    private static final String OS_VERSION = SystemUtils.getSystemProperty("os.version");
    public static final boolean IS_OS_LINUX = SystemUtils.startsWith(OS_NAME, "Linux") || SystemUtils.startsWith(OS_NAME, "LINUX");
    public static final boolean IS_OS_MAC = SystemUtils.startsWith(OS_NAME, "Mac OS");
    public static final boolean IS_OS_WINDOWS = SystemUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_2000 = SystemUtils.startsWith(OS_NAME, "Windows 2000");
    public static final boolean IS_OS_WINDOWS_XP = IS_OS_WINDOWS && SystemUtils.startsWith(OS_VERSION, "5.1");
    public static final boolean IS_LOW_RES = Toolkit.getDefaultToolkit().getScreenResolution() < 120;
    static /* synthetic */ Class class$com$jgoodies$uif$util$SystemUtils;

    private SystemUtils() {
    }

    public static void dumpProperties(PrintStream printStream, Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("line.separator")) continue;
            printStream.println(string + " = " + properties.getProperty(string));
        }
    }

    public static Properties getExtendedSystemProperties() {
        Properties properties = (Properties)System.getProperties().clone();
        SystemUtils.addSpecialProperties(properties);
        return properties;
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean systemExitAllowed() {
        return !"false".equals(SystemUtils.getSystemProperty("jgoodies.SystemExitAllowed"));
    }

    private static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            Logger.getLogger((class$com$jgoodies$uif$util$SystemUtils == null ? (class$com$jgoodies$uif$util$SystemUtils = SystemUtils.class$("com.jgoodies.uif.util.SystemUtils")) : class$com$jgoodies$uif$util$SystemUtils).getName()).warning("Can't access the System property " + string + ".");
            return "";
        }
    }

    private static void addSpecialProperties(Properties properties) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        properties.put("awt.screen.resolution", new Integer(toolkit.getScreenResolution()).toString());
        Dimension dimension = toolkit.getScreenSize();
        properties.put("awt.screen.size", dimension.width + " x " + dimension.height);
        properties.put("awt.colormodel", toolkit.getColorModel().getClass().getName());
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = l2 - l;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        properties.put("runtime.memory.used", numberFormat.format(l3));
        properties.put("runtime.memory.free", numberFormat.format(l));
        properties.put("runtime.memory.total", numberFormat.format(l2));
    }

    private static boolean startsWith(String string, String string2) {
        return string != null && string.startsWith(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

