/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.util;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static void collapseAllSiblings(JTree jTree, TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        TreeUtils.collapseChildren(jTree, treePath);
        for (treePath = treePath.getParentPath(); treePath != null; treePath = treePath.getParentPath()) {
            TreeNode treeNode2 = (TreeNode)treePath.getLastPathComponent();
            Enumeration<? extends TreeNode> enumeration = treeNode2.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode3 = enumeration.nextElement();
                if (treeNode3 == treeNode) continue;
                TreePath treePath2 = treePath.pathByAddingChild(treeNode3);
                jTree.collapsePath(treePath2);
            }
            treeNode = treeNode2;
        }
    }

    public static void collapseChildren(JTree jTree, TreePath treePath) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        Enumeration<? extends TreeNode> enumeration = treeNode.children();
        while (enumeration.hasMoreElements()) {
            TreeNode treeNode2 = enumeration.nextElement();
            TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
            jTree.collapsePath(treePath2);
        }
        jTree.collapsePath(treePath);
    }

    public static void expand(JTree jTree, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = jTree.getRowCount(); j >= 0; --j) {
                jTree.expandRow(j);
            }
        }
    }

    public static void expandTopLevel(JTree jTree) {
        TreeUtils.expand(jTree, 1);
    }
}

