/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.uif.util;

import com.jgoodies.uif.AbstractFrame;
import com.jgoodies.uif.util.ScreenUtils;
import com.jgoodies.uif.util.SystemUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;

public final class WindowUtils {
    private static final String WINDOW_ID_METHOD_NAME = "getWindowID";
    private static final String MIN_SIZE_METHOD_NAME = "getWindowMinimumSize";
    private static final String WINDOW_BOUNDS_KEYPART = "window.bounds";
    private static final String FRAME_STATE_KEYPART = "frame.state";
    private static final String STORED_BOUNDS_KEY = "stored.bounds";

    private WindowUtils() {
    }

    public static void setImageIcon(Frame frame, Image image, Image image2) {
        Image image3;
        Image image4;
        if (SystemUtils.IS_OS_MAC) {
            image4 = null;
            image3 = null;
        } else if (SystemUtils.IS_OS_WINDOWS_2000 && SystemUtils.IS_LOW_RES) {
            image4 = image;
            image3 = image2;
        } else {
            image4 = image2;
            image3 = image;
        }
        frame.setIconImage(image4 != null ? image4 : image3);
    }

    public static void storeBounds(Preferences preferences, JWindow jWindow) {
        preferences.put(WindowUtils.windowBoundsKey(jWindow), WindowUtils.encodeRectangle(jWindow.getBounds()));
    }

    public static void storeBounds(Preferences preferences, JDialog jDialog) {
        preferences.put(WindowUtils.windowBoundsKey(jDialog), WindowUtils.encodeRectangle(jDialog.getBounds()));
    }

    public static void storeBounds(Preferences preferences, JFrame jFrame) {
        Rectangle rectangle = WindowUtils.isMaximizedBoth(jFrame) ? WindowUtils.getStoredBounds(jFrame) : jFrame.getBounds();
        preferences.put(WindowUtils.windowBoundsKey(jFrame), WindowUtils.encodeRectangle(rectangle));
    }

    public static void storeState(Preferences preferences, Frame frame) {
        preferences.put(WindowUtils.frameStateKey(frame), Integer.toString(frame.getExtendedState()));
    }

    public static void restoreBounds(JWindow jWindow, Preferences preferences) {
        Rectangle rectangle = WindowUtils.decodeRectangle(preferences.get(WindowUtils.windowBoundsKey(jWindow), ""));
        if (rectangle != null) {
            jWindow.setBounds(rectangle);
        }
    }

    public static void restoreBounds(JDialog jDialog, Preferences preferences) {
        Rectangle rectangle = WindowUtils.decodeRectangle(preferences.get(WindowUtils.windowBoundsKey(jDialog), ""));
        if (rectangle != null) {
            jDialog.setBounds(rectangle);
        }
    }

    public static void restoreBounds(JFrame jFrame, Preferences preferences) {
        Rectangle rectangle = WindowUtils.getStoredBounds(jFrame, preferences);
        if (rectangle != null) {
            jFrame.setBounds(rectangle);
        }
        WindowUtils.setStoredBounds(jFrame, jFrame.getBounds());
    }

    public static Rectangle getStoredBounds(JFrame jFrame, Preferences preferences) {
        return WindowUtils.decodeRectangle(preferences.get(WindowUtils.windowBoundsKey(jFrame), ""));
    }

    public static void restoreState(Frame frame, Preferences preferences) {
        WindowUtils.restoreState(frame, preferences, true);
    }

    public static void restoreState(Frame frame, Preferences preferences, boolean bl) {
        int n = WindowUtils.getStoredState(frame, preferences);
        if (n == -1) {
            return;
        }
        if (n != 1 || !bl) {
            frame.setExtendedState(n);
        }
    }

    private static String windowBoundsKey(Window window) {
        String string = WindowUtils.getWindowID(window);
        if (string == null) {
            throw new IllegalArgumentException("The window must provide an ID:" + window);
        }
        return string + '.' + WINDOW_BOUNDS_KEYPART + '.' + ScreenUtils.encodedScreenConfiguration(window.getToolkit());
    }

    private static String frameStateKey(Frame frame) {
        String string = WindowUtils.getWindowID(frame);
        if (string == null) {
            throw new IllegalArgumentException("The frame must provide an ID:" + frame);
        }
        return string + '.' + FRAME_STATE_KEYPART + '.' + ScreenUtils.encodedScreenConfiguration(frame.getToolkit());
    }

    private static String getWindowID(Window window) {
        if (window instanceof AbstractFrame) {
            return ((AbstractFrame)window).getWindowID();
        }
        try {
            Method method = window.getClass().getMethod(WINDOW_ID_METHOD_NAME, null);
            return (String)method.invoke((Object)window, (Object[])null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private static Dimension getWindowMinimumSize(Window window) {
        if (window instanceof AbstractFrame) {
            return ((AbstractFrame)window).getWindowMinimumSize();
        }
        try {
            Method method = window.getClass().getMethod(MIN_SIZE_METHOD_NAME, null);
            return (Dimension)method.invoke((Object)window, (Object[])null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private static Object getClientProperty(Window window, String string) {
        return WindowUtils.getRootPane(window).getClientProperty(string);
    }

    private static void putClientProperty(Window window, String string, Object object) {
        WindowUtils.getRootPane(window).putClientProperty(string, object);
    }

    private static JComponent getRootPane(Window window) {
        if (window instanceof JWindow) {
            return ((JWindow)window).getRootPane();
        }
        if (window instanceof JFrame) {
            return ((JFrame)window).getRootPane();
        }
        throw new IllegalArgumentException("WindowUtils.getRootPane(Window) must be invoked on a JWindow, JDialog or JFrame.");
    }

    private static String encodeRectangle(Rectangle rectangle) {
        return Integer.toString(rectangle.x) + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height;
    }

    private static Rectangle decodeRectangle(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            return new Rectangle(n, n2, n3, n4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isMaximizedBoth(Frame frame) {
        return frame.getExtendedState() == 6;
    }

    private static Rectangle getStoredBounds(JFrame jFrame) {
        return (Rectangle)WindowUtils.getClientProperty(jFrame, STORED_BOUNDS_KEY);
    }

    private static void setStoredBounds(JFrame jFrame, Rectangle rectangle) {
        WindowUtils.putClientProperty(jFrame, STORED_BOUNDS_KEY, rectangle);
    }

    private static int getStoredState(Frame frame, Preferences preferences) {
        String string = preferences.get(WindowUtils.frameStateKey(frame), "");
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static class SizeChangeHandler
    extends ComponentAdapter {
        private final Window window;

        public SizeChangeHandler(JWindow jWindow) {
            this.window = jWindow;
        }

        public SizeChangeHandler(JDialog jDialog) {
            this.window = jDialog;
        }

        public SizeChangeHandler(JFrame jFrame) {
            this.window = jFrame;
        }

        public void componentResized(ComponentEvent componentEvent) {
            JFrame jFrame;
            Dimension dimension = WindowUtils.getWindowMinimumSize(this.window);
            if (dimension != null) {
                this.window.setSize(Math.max(dimension.width, this.window.getWidth()), Math.max(dimension.height, this.window.getHeight()));
            }
            if (this.window instanceof JFrame && (jFrame = (JFrame)this.window).isVisible() && !WindowUtils.isMaximizedBoth(jFrame)) {
                WindowUtils.setStoredBounds(jFrame, jFrame.getBounds());
            }
        }
    }
}

